module NumberGame exposing (main)

import Browser
import Html exposing (Html)
import Html.Attributes
import Html.Events



-- MODEL


type alias Model =
    Int


init : Model
init =
    0



-- UPDATE


type Msg
    = AddOne


update : Msg -> Model -> Model
update message model =
    case message of
        AddOne ->
            model + 1



-- VIEW


view : Model -> Html Msg
view model =
    Html.div []
        [ Html.div []
            [ Html.h3 []
                [ Html.text (String.fromInt model) ]
            ]
        , Html.div []
            [ Html.button [ Html.Events.onClick AddOne ]
                [ Html.text "Forøg" ]
            ]
        ]



-- MAIN - Koden herunder behøves ikke modifikation.


main : Program () Model Msg
main =
    Browser.sandbox
        { init = init
        , update = update
        , view = \model -> Html.div [] [ stylesheet, view model ]
        }


stylesheet : Html msg
stylesheet =
    Html.div []
        [ Html.node "link"
            [ Html.Attributes.rel "stylesheet"
            , Html.Attributes.href "/assets/simple.min.css"
            ]
            []
        , Html.node "link"
            [ Html.Attributes.rel "stylesheet"
            , Html.Attributes.href "/assets/numbergame.css"
            ]
            []
        ]
